package org.msh.tb.bd.tbforms.dhis2.tb11.blockbuilders;

import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.indicator.tb11.TBForm11;
import org.msh.tb.bd.tbforms.query.tb11.*;
import org.msh.tb.entities.enums.*;

public class TBForm11Block3TestedBuilder extends TBFormBlockBuilder {
    private TBForm11Block3TestedQuery blockQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        long zero = 0;
        for (TB11Column c : TB11Column.values()) {
            // no need to send grand total or total registered
            if (!(c.equals(TB11Column.GRAND_TOTAL) || c.equals(TB11Column.TOTAL_REGISTERED))) {

                for (TB11Block3Row r : TB11Block3Row.values()) {
                    // no need to send total
                    if (!r.equals(TB11Block3Row.TOTAL)) {
                        payload.mergeDataValue(r.getTestedDataElementId(), c.getMaleCocDHIS2Id(), zero);
                        payload.mergeDataValue(r.getTestedDataElementId(), c.getFemaleCocDHIS2Id(), zero);
                    }
                }

            }
        }
    }

    @Override
    protected TBForm11Block3TestedQuery getBlockQuery() {
        if (blockQuery == null) {
            blockQuery = new TBForm11Block3TestedQuery();
        }
        return blockQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        TBForm11.SuperColumn superColumn = TBForm11.SuperColumn.values()[(Integer)result[0]];

        switch(superColumn) {
            case SUCCESSFULLY_TREATED_UNTIL_14:
                mountResultPayloadSuccessTreat(result, payload, TB11Column.SUCCESSFULLY_TREATED_UNTIL_14);
                break;
            case SUCCESSFULLY_TREATED_AFTER_14:
                mountResultPayloadSuccessTreat(result, payload, TB11Column.SUCCESSFULLY_TREATED_AFTER_14);
                break;
            case OTHER_OUTCOMES:
                mountResultPayloadOtherOutcomes(result, payload);
                break;
        }
    }

    public void mountResultPayloadSuccessTreat(Object[] result, DataValuePayload payload, TB11Column successColumn) {
        PatientType pt = (PatientType) result[1];
        InfectionSite is = (InfectionSite) result[2];
        CaseDefinition cd = (CaseDefinition) result[3];
        Gender g = (Gender) result[4];
        Long qtd = (Long) result[5];

        payload.mergeDataValue(TB11Block3Row.getRow(is, pt, cd).getTestedDataElementId(),
                successColumn.getDHIS2CocId(g),
                qtd);
    }

    public void mountResultPayloadOtherOutcomes(Object[] result, DataValuePayload payload) {
        PatientType pt = (PatientType) result[1];
        InfectionSite is = (InfectionSite) result[2];
        CaseDefinition cd = (CaseDefinition) result[3];
        Gender g = (Gender) result[4];
        CaseState cs = (CaseState) result[5];
        Long qtd = (Long) result[6];

        payload.mergeDataValue(TB11Block3Row.getRow(is, pt, cd).getTestedDataElementId(),
                TB11Column.getDHIS2CocId(cs, g),
                qtd);
    }
}
